
use "${dir3}DEMO_distretto.dta", replace

egen dist=group(dist)
g macro_area=1 if dist==3
replace macro_area=1 if dist==4
replace macro_area=1 if dist==11
replace macro_area=1 if dist==15
replace macro_area=1 if dist==23
replace macro_area=1 if dist==24
replace macro_area=1 if dist==25
replace macro_area=1 if dist==26

replace macro_area=2 if dist==1
replace macro_area=2 if dist==7
replace macro_area=2 if dist==10
replace macro_area=2 if dist==12
replace macro_area=2 if dist==18
replace macro_area=2 if dist==21

replace macro_area=3 if macro_==.

merge 1:m distretto  using "${dir3}/POL19852011_turnover.dta", keep(master matched)
drop _m
merge 1:1 period distr using "${dir3}/crime_istat_clean.dta"

drop _m
merge 1:1 period distr using "${dir3}//gdp1.dta"

g sh_mi_1992=mag_indip_1992/(votanti_1992)
g sh_mi_1988=mag_indip_1988/(votivalidi_1988+schedenulle_1988+schedebianche_1988)
g sh_md_1992=mag_demo_1992/(votanti_1992)
g sh_md_1988=mag_demo_1988/(votivalidi_1988+schedenulle_1988+schedebianche_1988)
for any md mi: egen sd_X_1988=sd(sh_X_1988)
for any md mi: replace sh_X_1988=sh_X_1988/sd_X_1988

for any pecmalv_del del_tot: gen X2=X*1000
statsmat sh_md_1988 pecmalv_del2 del_tot2 same_mayor same_party vapro, stat(mean sd) listwise format(%20.3f) matrix(prov_demo)
outtable using "${dir5}prov_demo", replace nobox format( %20.3fc) label mat(prov_demo)
for any pecmalv_del del_tot: drop X2

for any pecmalv_per_tot om_atti_per_tot per_tot pa_per_tot: replace X=ln(X)
for any pecmalv_del_tot om_atti_del_tot del_tot pa_del_tot: replace X=ln(X)
g lnvapro=log(vapro)

global macro=""

g lnmpop=log(mpop)
egen newd=group(distretto)

for any 1 2 3 : g sh_md_1988X=sh_md_1988*(period==X)

drop sh_md_1988

* no district FE

xi: reghdfe pecmalv_del sh_md_1988* $macro [aw=mpop], a(period) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons replace ct(corruption) label 

xi: reghdfe del_tot sh_md_1988* $macro [aw=mpop], a(period) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons append ct(total crime rate) label 

xi: reghdfe same_m sh_md_1988* $macro [aw=mpop], a(period) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons append ct(same mayor) label 

xi: reghdfe same_p sh_md_1988* $macro [aw=mpop], a(period) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons append ct(same party) label 

xi: reghdfe lnvap sh_md_1988* $macro [aw=mpop], a(period) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons append ct(added value pc) label 

* with district FE

drop sh_md_19881
xi: reghdfe pecmalv_del sh_md_1988* $macro [aw=mpop], a(newd period) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons append ct(corruption) label 

xi: reghdfe del_tot sh_md_1988* $macro [aw=mpop], a(period newd) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons append ct(total crime rate) label 

xi: reghdfe same_m sh_md_1988* $macro [aw=mpop], a(period newd) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons append ct(same mayor) label 

xi: reghdfe same_p sh_md_1988* $macro [aw=mpop], a(period newd) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons append ct(same party) label 

xi: reghdfe lnvap sh_md_1988* $macro [aw=mpop], a(period newd) 
outreg2 sh_md_1988* using "${dir5}het_by_distA", tex bdec(3) nocons append ct(added value pc) label 





*******************************
use if age<=65 using "${dir3}mergedCF1_noPA", clear

capture log close
log using "${dir5}marco2.log", replace

bysort id: egen tot=count(year)
keep if tot!=. & tot!=1
drop tot

bysort CF1 c_b year: egen pippo=count(year)
bysort CF1 c_b: egen fr_c_new=median(pippo)
keep if fr_c_new<=30
drop pippo fr_c_new


merge m:1 distretto using "${dir3}DEMO_distretto.dta", keep(master matched)
drop _m

cap drop tmp
g tmp=n_pols-(n_pols_ing-n_pols_out)
replace n_pols_ing=n_pols_ing+tmp

reg n_pols n_pols_ing n_pols_out

g sh_mi_1992=mag_indip_1992/(votanti_1992)

g sh_mi_1988=mag_indip_1988/(votivalidi_1988+schedenulle_1988+schedebianch	e_1988)
g sh_md_1992=mag_demo_1992/(votanti_1992)
for any 88 : g sh_md_19X=mag_demo_19X/(votivalidi_19X+schedenulle_19X+schedebianche_19X)
for any md mi: egen sd_X_1988=sd(sh_X_1988)
for any md mi: replace sh_X_1988=sh_X_1988/sd_X_1988
for any md mi: egen sd_X_1992=sd(sh_X_1992)
for any md mi: replace sh_X_1992=sh_X_1992/sd_X_1992


g period=1 if (year<1992)
replace period=2 if year>=1992 & year<=2000
replace period=3 if year>2000 & year<.

g n_pols_ing1=n_pols_ing if per==1
g n_pols_ing2=n_pols_ing if per==2
g n_pols_ing3=n_pols_ing if per==3
for any 1 2 3: replace n_pols_ingX=0 if n_pols_ingX==. & year>1985


g n_pols_out1=n_pols_out if per==1
g n_pols_out2=n_pols_out if per==2
g n_pols_out3=n_pols_out if per==3
for any 1 2 3: replace n_pols_outX=0 if n_pols_outX==. & year>1985

g n_pols1=n_pols if per==1
g n_pols2=n_pols if per==2
g n_pols3=n_pols if per==3
for any 1 2 3: replace n_polsX=0 if n_polsX==. & year>1985



g inter_ing=n_pols_ing*sh_md_1988
g inter_out=n_pols_out*sh_md_1988
g inter=n_pols*sh_md_1988

for any ing ing1 out out1: g coef_X=.
for any ing ing1 out out1: g se_X=.

for any 1 2 3: g inter_ingX=inter_ing*(period==X)
for any 1 2 3: g inter_outX=inter_out*(period==X)

keep tot_wg n_paid_m emp inter_ing1-inter_ing3 inter_out1-inter_out3 period n_pols_ing   n_pols_out    p_b year newd aged id c_b

cap program drop regnow
program define regnow

xi: reghdfe $y   inter_ing1-inter_ing3 inter_out1-inter_out3, a(period##c.n_pols_ing   period##c.n_pols_out    p_b##year newd#aged id) vce(cluster c_b)
outreg2  inter_ing1-inter_ing3 using "${dir5}het_by_dist", tex bdec(3) nocons $append ct($y) label 

end



cap program drop regnow1
program define regnow1
xi: reghdfe $y   inter_ing2-inter_ing3 inter_out2-inter_out3, a(period##c.n_pols_ing  newd##c.n_pols_ing period##c.n_pols_out  newd##c.n_pols_out  p_b##year newd#aged id) vce(cluster c_b)
outreg2  inter_ing2-inter_ing3 using "${dir5}het_by_distA", tex bdec(3) nocons append ct($y) label 
 
end


 
 
 global append="replace"
 global y="tot_wg"
 regnow
 global append="append"
 global y="n_paid_m"
 regnow
 global y="empl"
 regnow
 global y="tot_wg"
 regnow1
 global y="n_paid_m"
 regnow1
 global y="empl"
 regnow1
 
 
